/** @file   StreamUtils.h
 * @brief   Declaration of StreamUtils class.
 * @version $Revision: 1.1.1.1 $
 * @date    $Date: 2006/01/21 23:02:38 $
 * @author  Tomi Lamminsaari
 */

#ifndef H_ENG2D_STREAMUTILS_H
#define H_ENG2D_STREAMUTILS_H

#include <iostream>
#include <string>
#include "eng2d_dll.h"

namespace eng2d {

/** @class  StreamUtils
 * @brief
 * @author  Tomi Lamminsaari
 *
 */
class DLLIMPORT StreamUtils
{
public:

    ///
    /// Constants, datatypes and static methods
    /// =======================================

    /** Reads the stream as long as the given tag is found.
     * @param   aIn             The stream to read from.
     * @param   aTag            The tag we search for.
     * @return  KErrNone if tag was found. KErrNotFound if tag was not
     *          found before EOF.
     */
    static int SearchForTag( std::istream& aIn,
                             const std::string& aTag );
    
    /** Skips a comment line from given stream.
     * @param   aIn             The stream we access.
     */
//    static void skipCommentLine( std::isteam& aIn );
    

    ///
    /// Constructors, destructor and operators
    /// ======================================

    /** Default constructor.
     */
    StreamUtils();

    /** Destructor
     */
    virtual ~StreamUtils();

    /** Copy constructor
     * @param   aAnother          Reference to another StreamUtils
     */
    StreamUtils( const StreamUtils& aAnother );

    /** An assignment operator
     * @param   aAnother          Reference to another StreamUtils
     * @return  Reference to this object.
     */
    StreamUtils& operator= ( const StreamUtils& aAnother );


    ///
    /// Inherited methods
    /// =================


    ///
    /// New public methods
    /// ==================


    ///
    /// Getter methods
    /// ==============


protected:
    ///
    /// Protected interface
    /// ===================


protected:
    ///
    /// Data members
    /// ============

};

};

#endif
